<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template name="PackageFrame">
		<xsl:param name="package"></xsl:param>
		
		<html>
		<head>
			<xsl:call-template name="ImportCSS"/>
		<title>Package frame</title>
		<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
		
		<!--script language="JavaScript">
			function doClick(imageHref) {
				if (parent.imageFrame != null)
			   parent.imageFrame.location.href = imageHref;
			}
		</script-->
		<xsl:call-template name="ImgLoaderScript"/>
		</head>
		<body>
		<font size="+1" class="FrameTitleFont">

		<xsl:apply-templates select="$package" mode="HRefWithImgLoad"/>
		</font>
		<p/>
		
		<!-- Diagrams -->	
		<xsl:variable name="diagrams" select="$package/Diagram"></xsl:variable>
		<xsl:if test="$diagrams">

			<table border="0" width="100%">
			<tr>
			<td nowrap="nowrap">
			<font size="+1" class="FrameHeadingFont">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'diagrams'"></xsl:with-param>
			</xsl:call-template>
			</font>
			<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
			<font class="FrameItemFont">
			<br/>
			
			<!-- @see allclasses_frame.xsl -->
			<xsl:call-template name="printDiagramList">
				<xsl:with-param name="diagrams" select="$diagrams"></xsl:with-param>
			</xsl:call-template>
			
			</font>
			</td>
			</tr>
			</table>					
		</xsl:if>
		
		<!-- Interfaces -->
		<xsl:variable name="interfaces" select="$package/Classifier[@type='Interface']"></xsl:variable>
		<xsl:if test="$interfaces">
			<p/>
			<table border="0" width="100%">
			<tr>
			<td nowrap="nowrap">
			<font size="+1" class="FrameHeadingFont">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'interfaces'"></xsl:with-param>
			</xsl:call-template>
			</font>
			<font class="FrameItemFont">
			<br/>
			
			<!-- @see allclasses_frame.xsl -->
			<xsl:call-template name="printClassifierList">
				<xsl:with-param name="classes" select="$interfaces"></xsl:with-param>
			</xsl:call-template>
			
			</font>
			</td>
			</tr>
			</table>					
		</xsl:if>
		
		<!-- Classes -->
		<xsl:variable name="classes" select="$package/Classifier[not(@type='Interface')]"></xsl:variable>
		<xsl:if test="$classes">
			<p/>
			<table border="0" width="100%">
			<tr>
			<td nowrap="nowrap">
			<font size="+1" class="FrameHeadingFont">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'classes'"></xsl:with-param>
			</xsl:call-template>
			</font>
			<font class="FrameItemFont">
			<br/>
			
			<!-- @see allclasses_frame.xsl -->
			<xsl:call-template name="printClassifierList">
				<xsl:with-param name="classes" select="$classes"></xsl:with-param>
			</xsl:call-template>
			
			</font>
			</td>
			</tr>
			</table>					
		</xsl:if>
		
		</body>
		</html>		
	</xsl:template>

</xsl:stylesheet>
